/*!
    \file  gd32f30x_libopt.h
    \brief library optional for gd32f30x
*/

/*
    Copyright (C) 2017 GigaDevice

    2017-05-19, V1.0.0, demo for GD32F30x
*/

#ifndef GD32F30X_LIBOPT_H
#define GD32F30X_LIBOPT_H

#include "gd32f30x_rcu.h"
#include "gd32f30x_adc.h"
#include "gd32f30x_can.h"
#include "gd32f30x_crc.h"
#include "gd32f30x_ctc.h"
#include "gd32f30x_dac.h"
#include "gd32f30x_dbg.h"
#include "gd32f30x_dma.h"
#include "gd32f30x_exti.h"
#include "gd32f30x_fmc.h"
#include "gd32f30x_fwdgt.h"
#include "gd32f30x_gpio.h"
#include "gd32f30x_i2c.h"
#include "gd32f30x_pmu.h"
#include "gd32f30x_bkp.h"
#include "gd32f30x_rtc.h"
#include "gd32f30x_sdio.h"
#include "gd32f30x_spi.h"
#include "gd32f30x_timer.h"
#include "gd32f30x_usart.h"
#include "gd32f30x_wwdgt.h"
#include "gd32f30x_misc.h"
#include "gd32f30x_exmc.h"
#ifdef GD32F30X_CL
#include "gd32f30x_enet.h"
#endif /* GD32F30X_CL */

#endif /* GD32F30X_LIBOPT_H */
